<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'MarketHub')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=outfit:400,500,600,700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }

        .glass-nav {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.3);
        }
    </style>
</head>

<body class="antialiased bg-gray-50 text-gray-800 font-sans">
    <div class="min-h-screen flex flex-col">
        <!-- Top Bar -->
        <div class="bg-slate-900 text-white text-xs py-2">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex justify-between items-center">
                <div class="flex space-x-4">
                    <span><i class="fas fa-phone-alt mr-1"></i> (+94) 773 940 838</span>
                    <span><i class="fas fa-envelope mr-1"></i> helpdesk@gariteam.com</span>
                </div>
                <div class="flex space-x-4">
                    <a href="#" class="hover:text-brand-400">Register Member</a>
                    <a href="#" class="hover:text-brand-400">Sign In</a>
                </div>
            </div>
        </div>

        <!-- Navbar -->
        <nav class="bg-white shadow-sm sticky top-0 z-50" x-data="{ mobileMenuOpen: false, searchOpen: false }">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-20 items-center">
                    <!-- Logo -->
                    <div class="flex-shrink-0 flex items-center">
                        <a href="<?php echo e(url('/')); ?>" class="flex items-center gap-2">
                            <img src="<?php echo e(asset('images/gari_logo.png')); ?>" alt="GARI Logo" class="h-16 w-auto">
                        </a>
                    </div>

                    <!-- Desktop Menu -->
                    <div class="hidden lg:flex items-center space-x-6">
                        <a href="<?php echo e(url('/')); ?>"
                            class="text-slate-900 font-medium hover:text-brand-600 transition text-sm">Home</a>

                        <!-- Conference Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                Conference <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Upcoming
                                    on 2025</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Upcoming
                                    on 2026</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Upcoming
                                    on 2027</a>
                            </div>
                        </div>

                        <!-- Speakers Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                Speakers <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute left-0 mt-2 w-56 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Co-chairs
                                    & Keynote</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Presenters
                                    - Upcoming</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Scientific
                                    Committee</a>
                            </div>
                        </div>

                        <!-- About Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                About <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute left-0 mt-2 w-56 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">About
                                    GARI</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Advisory
                                    Team</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">GARI
                                    Publications</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Journal
                                    Partners</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Academic
                                    Partners</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Country
                                    Ambassador</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Organizing
                                    Teams</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">CSR
                                    Project</a>
                            </div>
                        </div>

                        <!-- Registration Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                Registration <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute left-0 mt-2 w-64 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Presenter
                                    / Participant</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Co-Chair
                                    / Keynote</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Scientific
                                    Reviewer</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Apply
                                    for Journal Editorial Board</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Media
                                    Partner Apply</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Sponsor
                                    Apply</a>
                            </div>
                        </div>

                        <!-- Research Library Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                Research Library <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute right-0 mt-2 w-56 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Library</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Past
                                    Proceedings</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Abstract
                                    Guideline</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Full
                                    Paper Guideline</a>
                            </div>
                        </div>

                        <!-- History Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                History <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute right-0 mt-2 w-56 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Past
                                    Conferences</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Past
                                    Speakers</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Past
                                    Presenters</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Video
                                    Gallery</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Image
                                    Gallery</a>
                            </div>
                        </div>

                        <!-- Contact Dropdown -->
                        <div class="relative group">
                            <button
                                class="text-slate-600 font-medium hover:text-brand-600 transition text-sm flex items-center gap-1">
                                Contact <i class="fas fa-chevron-down text-[10px]"></i>
                            </button>
                            <div
                                class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 border border-gray-100">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Contact
                                    Us</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Visa
                                    Apply</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Accommodation</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">Venue</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-brand-50 hover:text-brand-600">FAQ</a>
                            </div>
                        </div>

                        <!-- Search Trigger -->
                        <button @click="searchOpen = !searchOpen"
                            class="text-slate-600 hover:text-brand-600 transition">
                            <i class="fas fa-search text-lg"></i>
                        </button>
                    </div>

                    <!-- Search Bar Overlay -->
                    <div x-show="searchOpen" @click.away="searchOpen = false"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="absolute top-full left-0 w-full bg-white shadow-md border-t border-gray-100 p-4 z-40"
                        style="display: none;">
                        <div class="max-w-3xl mx-auto flex items-center gap-4">
                            <div class="relative flex-grow">
                                <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                    <i class="fas fa-search text-gray-400"></i>
                                </span>
                                <input type="text"
                                    class="w-full py-4 pl-16 pr-16 text-gray-700 bg-gray-50 border border-gray-300 rounded-lg focus:outline-none focus:border-brand-500 focus:bg-white transition"
                                    placeholder="Search for conferences, speakers, or topics...">
                            </div>
                            <button @click="searchOpen = false" class="text-gray-500 hover:text-gray-700">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Mobile Menu Button -->
                    <div class="flex items-center lg:hidden">
                        <button @click="mobileMenuOpen = true"
                            class="text-slate-600 hover:text-brand-600 focus:outline-none">
                            <i class="fas fa-bars text-2xl"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Mobile Menu Overlay -->
            <div x-show="mobileMenuOpen" class="fixed inset-0 z-50 lg:hidden" role="dialog" aria-modal="true">
                <!-- Backdrop -->
                <div x-show="mobileMenuOpen" x-transition:enter="transition-opacity ease-linear duration-300"
                    x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                    x-transition:leave="transition-opacity ease-linear duration-300"
                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                    class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm" @click="mobileMenuOpen = false"></div>

                <!-- Menu Panel -->
                <div x-show="mobileMenuOpen" x-transition:enter="transition ease-in-out duration-300 transform"
                    x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
                    x-transition:leave="transition ease-in-out duration-300 transform"
                    x-transition:leave-start="translate-x-0" x-transition:leave-end="translate-x-full"
                    class="fixed inset-y-0 right-0 z-50 w-full max-w-xs bg-white shadow-2xl overflow-y-auto">

                    <div class="flex items-center justify-between px-6 py-5 border-b border-slate-100">
                        <a href="<?php echo e(url('/')); ?>">
                            <img src="<?php echo e(asset('images/gari_logo.png')); ?>" alt="GARI Logo" class="h-10 w-auto">
                        </a>
                        <button @click="mobileMenuOpen = false" class="text-slate-400 hover:text-slate-600">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>

                    <div class="px-6 py-6 space-y-6">
                        <a href="<?php echo e(url('/')); ?>"
                            class="block text-base font-bold text-slate-900 hover:text-brand-600">Home</a>

                        <!-- Conference Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>Conference</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Upcoming on
                                    2025</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Upcoming on
                                    2026</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Upcoming on
                                    2027</a>
                            </div>
                        </div>

                        <!-- Speakers Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>Speakers</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Co-chairs &
                                    Keynote</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Presenters -
                                    Upcoming</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Scientific
                                    Committee</a>
                            </div>
                        </div>

                        <!-- About Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>About</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">About
                                    GARI</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Advisory
                                    Team</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">GARI
                                    Publications</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Journal
                                    Partners</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Academic
                                    Partners</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Country
                                    Ambassador</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Organizing
                                    Teams</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">CSR
                                    Project</a>
                            </div>
                        </div>

                        <!-- Registration Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>Registration</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Presenter /
                                    Participant</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Co-Chair /
                                    Keynote</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Scientific
                                    Reviewer</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Apply for
                                    Journal Editorial Board</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Media
                                    Partner Apply</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Sponsor
                                    Apply</a>
                            </div>
                        </div>

                        <!-- Research Library Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>Research Library</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Library</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Past
                                    Proceedings</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Abstract
                                    Guideline</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Full Paper
                                    Guideline</a>
                            </div>
                        </div>

                        <!-- History Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>History</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Past
                                    Conferences</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Past
                                    Speakers</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Past
                                    Presenters</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Video
                                    Gallery</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Image
                                    Gallery</a>
                            </div>
                        </div>

                        <!-- Contact Mobile -->
                        <div x-data="{ open: false }">
                            <button @click="open = !open"
                                class="flex items-center justify-between w-full text-base font-medium text-slate-700 hover:text-brand-600">
                                <span>Contact</span>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200"
                                    :class="{ 'rotate-180': open }"></i>
                            </button>
                            <div x-show="open" x-collapse class="mt-3 space-y-2 pl-4 border-l-2 border-slate-100">
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Contact
                                    Us</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Visa
                                    Apply</a>
                                <a href="#"
                                    class="block text-sm text-slate-600 hover:text-brand-600 py-1">Accommodation</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">Venue</a>
                                <a href="#" class="block text-sm text-slate-600 hover:text-brand-600 py-1">FAQ</a>
                            </div>
                        </div>
                    </div>

                    <div class="p-6 border-t border-slate-100 bg-slate-50">
                        <div class="grid grid-cols-2 gap-4">
                            <a href="#"
                                class="flex items-center justify-center px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-brand-600 bg-brand-100 hover:bg-brand-200">
                                Sign In
                            </a>
                            <a href="#"
                                class="flex items-center justify-center px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-brand-600 hover:bg-brand-700">
                                Register
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="flex-grow">
            <?php echo e($slot); ?>

        </main>

        <!-- Mega Footer -->
        <footer class="bg-slate-900 text-slate-300 pt-16 pb-8 border-t border-slate-800 font-sans">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
                    <!-- About GARI -->
                    <div>
                        <div class="mb-6">
                            <a href="<?php echo e(url('/')); ?>" class="flex items-center gap-2">
                                <img src="<?php echo e(asset('images/gari_logo.png')); ?>" alt="GARI Logo"
                                    class="h-12 w-auto brightness-0 invert opacity-90">
                            </a>
                        </div>
                        <p class="text-sm text-slate-400 leading-relaxed mb-6">
                            Global Academic Research Institute (GARI) is a leading conference organizer, publishing
                            high-quality research and fostering global academic collaboration.
                        </p>
                        <div class="flex gap-4">
                            <a href="#"
                                class="w-9 h-9 rounded bg-slate-800 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition duration-300"><i
                                    class="fab fa-facebook-f"></i></a>
                            <a href="#"
                                class="w-9 h-9 rounded bg-slate-800 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition duration-300"><i
                                    class="fab fa-twitter"></i></a>
                            <a href="#"
                                class="w-9 h-9 rounded bg-slate-800 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition duration-300"><i
                                    class="fab fa-linkedin-in"></i></a>
                            <a href="#"
                                class="w-9 h-9 rounded bg-slate-800 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition duration-300"><i
                                    class="fab fa-youtube"></i></a>
                            <a href="#"
                                class="w-9 h-9 rounded bg-slate-800 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition duration-300"><i
                                    class="fab fa-instagram"></i></a>
                        </div>
                    </div>

                    <!-- Contact Us -->
                    <div>
                        <h3
                            class="text-white font-bold text-lg mb-6 relative inline-block after:content-[''] after:absolute after:-bottom-2 after:left-0 after:w-12 after:h-1 after:bg-indigo-600 after:rounded">
                            Contact Us</h3>
                        <ul class="space-y-4 text-sm">
                            <li class="flex items-start gap-3 group">
                                <i
                                    class="fas fa-map-marker-alt text-indigo-500 mt-1 group-hover:text-white transition"></i>
                                <span class="group-hover:text-white transition">GARI Conference,<br>87/23A, Kohila
                                    Kotuwa Road,<br>Neelammahara, Maharagama,<br>Colombo, Sri Lanka.</span>
                            </li>
                            <li class="flex items-center gap-3 group">
                                <i class="fas fa-phone-alt text-indigo-500 group-hover:text-white transition"></i>
                                <span class="group-hover:text-white transition">(+94) 112 849 268 / (+94) 773 940
                                    838</span>
                            </li>
                            <li class="flex items-center gap-3 group">
                                <i class="fab fa-whatsapp text-indigo-500 group-hover:text-white transition"></i>
                                <span class="group-hover:text-white transition">(+94) 715 279 696 / (+94) 703 866
                                    054</span>
                            </li>
                            <li class="flex items-center gap-3 group">
                                <i class="fas fa-envelope text-indigo-500 group-hover:text-white transition"></i>
                                <span class="group-hover:text-white transition">helpdesk@gariteam.com</span>
                            </li>
                            <li class="flex items-center gap-3 group">
                                <i class="fas fa-clock text-indigo-500 group-hover:text-white transition"></i>
                                <span class="group-hover:text-white transition">Mon - Fri: 8.30 AM - 5.00 PM</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Quick Links -->
                    <div>
                        <h3
                            class="text-white font-bold text-lg mb-6 relative inline-block after:content-[''] after:absolute after:-bottom-2 after:left-0 after:w-12 after:h-1 after:bg-indigo-600 after:rounded">
                            Quick Links</h3>
                        <ul class="space-y-3 text-sm">
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Home</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Upcoming Conferences</a>
                            </li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Speakers</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Registration</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Paper Submission</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Publication</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> About GARI</a></li>
                        </ul>
                    </div>

                    <!-- Information -->
                    <div>
                        <h3
                            class="text-white font-bold text-lg mb-6 relative inline-block after:content-[''] after:absolute after:-bottom-2 after:left-0 after:w-12 after:h-1 after:bg-indigo-600 after:rounded">
                            Information</h3>
                        <ul class="space-y-3 text-sm">
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Visa Apply</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Accommodation</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Conference Venue</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Conference Tour</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Gallery</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> FAQ</a></li>
                            <li><a href="#"
                                    class="hover:text-indigo-400 hover:pl-2 transition-all duration-300 flex items-center gap-2"><i
                                        class="fas fa-angle-right text-xs text-slate-600"></i> Contact Us</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Bottom Bar -->
                <div
                    class="border-t border-slate-800 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
                    <div class="text-sm text-slate-500 text-center md:text-left">
                        <p>&copy; <?php echo e(date('Y')); ?> Global Academic Research Institute. All rights reserved.</p>
                    </div>

                    <!-- Payment Methods -->
                    <div class="flex items-center gap-4 text-slate-400 text-2xl">
                        <i class="fab fa-cc-visa hover:text-white transition"></i>
                        <i class="fab fa-cc-mastercard hover:text-white transition"></i>
                        <i class="fab fa-cc-amex hover:text-white transition"></i>
                        <i class="fab fa-cc-paypal hover:text-white transition"></i>
                    </div>

                    <div class="flex gap-6 text-xs text-slate-500">
                        <a href="#" class="hover:text-indigo-400 transition">Privacy Policy</a>
                        <a href="#" class="hover:text-indigo-400 transition">Terms of Service</a>
                        <a href="#" class="hover:text-indigo-400 transition">Cookie Policy</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
</body>

</html><?php /**PATH /home/gariteam/public_html/dev.gariteam.com/resources/views/layouts/main.blade.php ENDPATH**/ ?>