<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', [App\Http\Controllers\HomeController::class, 'index']);
Route::get('/guidelines', function () {
    return view('guidelines');
})->name('guidelines');

Route::get('/publications/{year}', function ($year) {
    // In a real app, this would fetch data from DB
    return "<h1>List of Publications for Year: " . htmlspecialchars($year) . "</h1><p>Full list coming soon...</p>";
})->name('publications.year');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';
