<?php

namespace App\Services;

class ConferenceService
{
    public function getAllConferences()
    {
        return [
            [
                'id' => 7,
                'slug' => 'business-management-economics-spain-2026',
                'title' => 'Business Management & Economics',
                'subtitle' => 'New Approaches in Economics and Business: Problems & Opportunities',
                'date' => 'Mar 28-29, 2026',
                'time' => '09:00 AM - 05:00 PM',
                'formatted_date' => '28 Mar',
                'deadline' => 'Mar 10, 2026',
                'location' => 'Barcelona, Spain',
                'venue' => 'Barcelona Conference Center',
                'country' => 'Spain',
                'category' => 'Business',
                'image' => 'https://images.unsplash.com/photo-1583422409516-2895a77efded?q=80&w=2940&auto=format&fit=crop',
                'description' => 'A premier international forum for researchers, practitioners, and educators to present and discuss the most recent innovations, trends, and concerns in the fields of Business Management and Economics.',
                'call_for_papers' => [
                    'text' => 'As a scientific research conference organizer, The Global Academic Research Institute is proudly organizing the International Conference on Business Management and Economics (ICBME 2026) under the theme of "New Approaches in Economics and Business: Problems & Opportunities." We welcome proposals for papers and invitations for abstract submissions, which are now open for both oral and poster presentations covering current research and new processes. All contributions should be of high quality. During the review period, Papers will be reviewed by eminent scholars in the respective areas. Two types of submissions are invited: Full papers reporting on original and unpublished research, and Work-in-progress papers or Abstract or Case Studies or Projects.',
                    'link' => '#'
                ],
                'important_dates' => [
                    ['label' => 'Abstract Submission Deadline', 'date' => '3rd February 2026'],
                    ['label' => 'Notification of Acceptance', 'date' => 'Within 07 Days'],
                    ['label' => 'Full Paper Submission', 'date' => '10th March 2026'],
                    ['label' => 'Registration Deadline', 'date' => '28th February 2026'],
                    ['label' => 'Conference Date', 'date' => '28, 29 Mar 2026']
                ],
                'scopes' => [
                    'Strategic Management' => [
                        'Strategic Management & Competitive Advantage',
                        'Organizational Theory & Change',
                        'Leadership, Innovation & High Performance',
                        'Corporate Governance & Ethical Management',
                        'Knowledge & Innovation Management'
                    ],
                    'Marketing & Digital Strategies' => [
                        'Marketing Management & Consumer Behaviour',
                        'Digital Marketing, E-commerce & Social Media',
                        'Branding, Advertising & Sales Strategies',
                        'Market Analytics & Customer Insights',
                        'Service Marketing & Experience Management'
                    ],
                    'Finance & Accounting' => [
                        'Corporate Finance & Investment Analysis',
                        'Financial Reporting & Auditing',
                        'Risk Management & Financial Instruments',
                        'Capital Markets, Banking & Fintech',
                        'Sustainable Finance & Behavioural Finance'
                    ],
                    'Human Resource' => [
                        'Talent Acquisition, Development & Retention',
                        'Performance Management & Motivation',
                        'Diversity, Equity & Organizational Culture',
                        'HR Analytics & Strategic HRM',
                        'Workplace Well-being & Leadership Development'
                    ],
                    'Economics' => [
                        'Microeconomics & Macroeconomics',
                        'Development Economics & Growth Models',
                        'Monetary & Fiscal Policy Analysis',
                        'International Economics & Trade Policy',
                        'Economic Inequality, Poverty & Public Policy'
                    ],
                    'Entrepreneurship' => [
                        'Entrepreneurial Ecosystems & Venture Creation',
                        'Small & Medium Enterprises (SMEs)',
                        'Innovation, Technology Adoption & Startups',
                        'Social Entrepreneurship & Inclusive Business'
                    ],
                    'Operations & Logistics' => [
                        'Supply Chain Design, Management & Resilience',
                        'Operations Strategy & Process Improvement',
                        'Quality & Productivity Management',
                        'Sustainable Logistics & Green Supply Chains',
                        'Procurement & Supplier Relationship Management'
                    ],
                    'Business Analytics & AI' => [
                        'Big Data Analytics & Business Intelligence',
                        'AI/ML applications in business',
                        'Digital transformation in organisations',
                        'Predictive modelling and forecasting',
                        'Cybersecurity and data governance'
                    ]
                ],
                'theme' => [
                    'primary' => '#1e3a8a', // Blue 900
                    'secondary' => '#172554', // Blue 950
                    'accent' => '#93c5fd', // Blue 300
                    'gradient' => 'from-blue-900 to-indigo-950',
                ],
                'logo_text' => 'BUS:SPEC',
                'stats' => [
                    ['label' => 'Papers', 'value' => '80+'],
                    ['label' => 'Countries', 'value' => '30'],
                    ['label' => 'Workshops', 'value' => '5'],
                ],
                'speakers' => [
                    // Placeholders as none listed on source yet
                    ['name' => 'Prof. Elena Rodriguez', 'role' => 'Economic Strategy', 'company' => 'Univ. of Barcelona', 'image' => 'https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?q=80&w=688&auto=format&fit=crop'],
                    ['name' => 'Dr. Mark Thompson', 'role' => 'Business Analyst', 'company' => 'Global Finance', 'image' => 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?q=80&w=1170&auto=format&fit=crop'],
                    ['name' => 'Dr. James Carter', 'role' => 'Market Research', 'company' => 'Innovation Hub', 'image' => 'https://images.unsplash.com/photo-1560250097-0b93528c311a?q=80&w=687&auto=format&fit=crop'],
                    ['name' => 'Prof. Sarah Chen', 'role' => 'Global Trade', 'company' => 'Asia Pacific Inst', 'image' => 'https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=761&auto=format&fit=crop'],
                    ['name' => 'Dr. Michael Ross', 'role' => 'Fintech Specialist', 'company' => 'Tech Solutions', 'image' => 'https://images.unsplash.com/photo-1519085360753-af0119f7cbe7?q=80&w=687&auto=format&fit=crop'],
                    ['name' => 'Ms. Linda Green', 'role' => 'Sustainable Business', 'company' => 'Eco Ventures', 'image' => 'https://images.unsplash.com/photo-1598550874175-4d7112ee7f43?q=80&w=687&auto=format&fit=crop'],
                ],
                'schedule' => [
                    '28/03/2026' => [
                        'title' => 'Day 01: Economics & Strategy',
                        'events' => [
                            ['time' => '09:00 AM', 'title' => 'Registration & Opening', 'speaker' => 'Committee'],
                            ['time' => '10:00 AM', 'title' => 'Global Business Trends', 'speaker' => 'Prof. Elena Rodriguez'],
                        ]
                    ],
                    '29/03/2026' => [
                        'title' => 'Day 02: Management Innovation',
                        'events' => [
                            ['time' => '09:30 AM', 'title' => 'Digital Transformation in Management', 'speaker' => 'Dr. Mark Thompson'],
                        ]
                    ]
                ],
                'registration' => [
                    'international' => [
                        'title' => 'International Delegates',
                        'currency' => 'EUR',
                        'categories' => [
                            [
                                'name' => 'Presenter (Oral)',
                                'early_bird' => '300',
                                'regular' => '350',
                                'description' => 'For international researchers presenting papers.',
                                'benefits' => ['Presentation Slot (20 mins)', 'Conference Proceedings', 'Lunch & Refreshments', 'Certificate']
                            ],
                            [
                                'name' => 'Virtual Presenter',
                                'early_bird' => '200',
                                'regular' => '250',
                                'description' => 'Present remotely via Zoom.',
                                'benefits' => ['Online Access', 'E-Certificate', 'Publication of Abstract']
                            ],
                            [
                                'name' => 'Listener (Delegate)',
                                'early_bird' => '200',
                                'regular' => '250',
                                'description' => 'Attend sessions without presenting.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments']
                            ]
                        ]
                    ],
                    'domestic' => [
                        'title' => 'Domestic Delegates',
                        'currency' => 'EUR',
                        'categories' => [
                            [
                                'name' => 'Local Presenter',
                                'early_bird' => '200',
                                'regular' => '250',
                                'description' => 'For local researchers.',
                                'benefits' => ['Presentation Slot', 'Lunch & Tea', 'Certificate']
                            ],
                            [
                                'name' => 'Student',
                                'early_bird' => '150',
                                'regular' => '180',
                                'description' => 'Valid student ID required.',
                                'benefits' => ['Access to Sessions', 'Lunch & Tea', 'Certificate']
                            ]
                        ]
                    ]
                ],
            ],
            [
                'id' => 1,
                'slug' => 'ai-machine-learning-2026',
                'title' => 'Conference London', // Changed for visual matching to user request
                'subtitle' => 'International AI Summit',
                'date' => 'Oct 15-17 2026',
                'time' => '09:00 AM - 05:00 PM',
                'formatted_date' => '15 Oct',
                'deadline' => 'Aug 15, 2026',
                'location' => 'London, UK',
                'venue' => 'The O2 Arena',
                'country' => 'UK',
                'category' => 'Technology',
                'image' => 'https://images.unsplash.com/photo-1544531586-fde5298cdd40?q=80&w=2970&auto=format&fit=crop',
                'description' => 'Join leading experts to discuss the future of Artificial Intelligence and Machine Learning technologies.',
                'theme' => [
                    'primary' => '#FF4D00', // Orange/Red from reference
                    'secondary' => '#1a1a1a', // Dark background
                    'accent' => '#ffffff',
                    'gradient' => 'from-orange-600 to-red-900',
                ],
                'logo_text' => 'CONF:LDN',
                'stats' => [
                    ['label' => 'Speakers', 'value' => '50+'],
                    ['label' => 'Workshops', 'value' => '12'],
                    ['label' => 'Attendees', 'value' => '2500+'],
                    ['label' => 'Countries', 'value' => '45'],
                ],
                'speakers' => [
                    ['name' => 'Amelia Watson', 'role' => 'Lead AI Researcher', 'company' => 'DeepMind', 'image' => 'https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?q=80&w=688&auto=format&fit=crop'],
                    ['name' => 'James Chen', 'role' => 'CTO', 'company' => 'FutureTech', 'image' => 'https://images.unsplash.com/photo-1560250097-0b93528c311a?q=80&w=687&auto=format&fit=crop'],
                    ['name' => 'Sarah Connor', 'role' => 'Ethics Lead', 'company' => 'OpenAI', 'image' => 'https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=761&auto=format&fit=crop'],
                    ['name' => 'Robert Ford', 'role' => 'Director', 'company' => 'Delos', 'image' => 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?q=80&w=1170&auto=format&fit=crop'],
                ],
                'schedule' => [
                    '07/09/2026' => [
                        'title' => 'Day 01: The Future',
                        'events' => [
                            ['time' => '09:00 AM', 'title' => 'Opening Ceremony', 'speaker' => 'Dr. Smith'],
                            ['time' => '11:00 AM', 'title' => 'Generative Agents', 'speaker' => 'Amelia Watson'],
                        ]
                    ],
                    '08/09/2026' => [
                        'title' => 'Day 02: Ethics & Safety',
                        'events' => [
                            ['time' => '10:00 AM', 'title' => 'AI Alignment Panel', 'speaker' => 'Sarah Connor'],
                        ]
                    ]
                ],
                'registration' => [
                    'international' => [
                        'title' => 'International Delegates',
                        'currency' => 'USD',
                        'categories' => [
                            [
                                'name' => 'Presenter (Oral/Poster)',
                                'early_bird' => '350',
                                'regular' => '450',
                                'description' => 'For authors presenting their research paper.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments', 'Publication of Abstract']
                            ],
                            [
                                'name' => 'Virtual Presenter',
                                'early_bird' => '250',
                                'regular' => '300',
                                'description' => 'Present your research remotely via Zoom/Teams.',
                                'benefits' => ['Online Access to sessions', 'E-Certificate', 'Publication of Abstract']
                            ],
                            [
                                'name' => 'Student Presenter',
                                'early_bird' => '300',
                                'regular' => '350',
                                'description' => 'Discounted rate for full-time students.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments', 'Publication of Abstract']
                            ],
                            [
                                'name' => 'Listener (Delegate)',
                                'early_bird' => '200',
                                'regular' => '250',
                                'description' => 'Attend sessions without presenting.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments']
                            ]
                        ]
                    ],
                    'domestic' => [
                        'title' => 'Domestic (Local) Delegates',
                        'currency' => 'LKR',
                        'categories' => [
                            [
                                'name' => 'Presenter (Local)',
                                'early_bird' => '15,000',
                                'regular' => '20,000',
                                'description' => 'For local authors presenting research.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments', 'Publication of Abstract']
                            ],
                            [
                                'name' => 'Student (Local)',
                                'early_bird' => '10,000',
                                'regular' => '12,000',
                                'description' => 'Discounted rate for local students.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments']
                            ],
                            [
                                'name' => 'Listener (Local)',
                                'early_bird' => '8,000',
                                'regular' => '10,000',
                                'description' => 'Attend sessions as a listener.',
                                'benefits' => ['Access to all sessions', 'Conference Kit', 'Certificates', 'Lunch & Refreshments']
                            ]
                        ]
                    ]
                ],
            ],
            [
                'id' => 3,
                'slug' => 'ayurveda-2026',
                'title' => 'Ayurveda & Traditional Medicine',
                'subtitle' => 'International Conference on Medicinal Plants',
                'date' => 'Dec 10-12, 2026',
                'time' => '08:00 AM - 04:00 PM',
                'formatted_date' => '10 Dec',
                'deadline' => 'Oct 10, 2026',
                'location' => 'Colombo, Sri Lanka',
                'venue' => 'Galle Face Hotel',
                'country' => 'Sri Lanka',
                'category' => 'Health',
                'image' => 'https://images.unsplash.com/photo-1616394584738-fc6e612e71b9?q=80&w=2940&auto=format&fit=crop',
                'description' => 'Exploring the healing power of nature through Ayurveda, Siddha, Unani and traditional systems of medicine.',
                'theme' => [
                    'primary' => '#166534', // Green 700
                    'secondary' => '#064E3B', // Green 900
                    'accent' => '#D9F99D', // Lime 200
                    'gradient' => 'from-green-800 to-lime-900',
                ],
                'logo_text' => 'AYU:VEDA',
                'stats' => [
                    ['label' => 'Papers', 'value' => '120+'],
                    ['label' => 'Countries', 'value' => '25'],
                    ['label' => 'Practitioners', 'value' => '300+'],
                ],
                'speakers' => [
                    ['name' => 'Dr. A. Sharma', 'role' => 'Ayurvedic Specialist', 'company' => 'India Institute of Ayurveda', 'image' => 'https://images.unsplash.com/photo-1612349317150-e413f6a5b16d?q=80&w=2070&auto=format&fit=crop'],
                    ['name' => 'Prof. K. Perera', 'role' => 'Herbal Researcher', 'company' => 'University of Colombo', 'image' => 'https://images.unsplash.com/photo-1559839734-2b71ea197ec2?q=80&w=2070&auto=format&fit=crop'],
                    ['name' => 'Dr. Li Wei', 'role' => 'TCM Expert', 'company' => 'Beijing Medical Univ', 'image' => 'https://images.unsplash.com/photo-1537368910025-700350fe46c7?q=80&w=2070&auto=format&fit=crop'],
                    ['name' => 'Dr. Sarah Jones', 'role' => 'Holistic Health', 'company' => 'Wellness UK', 'image' => 'https://images.unsplash.com/photo-1594824476969-2335878090b7?q=80&w=2070&auto=format&fit=crop'],
                ],
                'schedule' => [
                    '10/12/2026' => [
                        'title' => 'Day 01: Foundations',
                        'events' => [
                            ['time' => '08:30 AM', 'title' => 'Traditional Knowledge Systems', 'speaker' => 'Dr. A. Sharma'],
                            ['time' => '10:30 AM', 'title' => 'Medicinal Plant Conservation', 'speaker' => 'Prof. K. Perera'],
                        ]
                    ],
                    '11/12/2026' => [
                        'title' => 'Day 02: Clinical Practice',
                        'events' => [
                            ['time' => '09:00 AM', 'title' => 'Integrative Medicine Workshop', 'speaker' => 'Dr. Sarah Jones'],
                        ]
                    ]
                ],
                'registration' => [
                    'international' => [
                        'title' => 'International Delegates',
                        'currency' => 'USD',
                        'categories' => [
                            [
                                'name' => 'Presenter (Oral)',
                                'early_bird' => '300',
                                'regular' => '400',
                                'description' => 'For international researchers presenting papers.',
                                'benefits' => ['15 min Presentation Slot', 'Conference Proceedings', 'Lunch & Tea', 'Certificate']
                            ],
                            [
                                'name' => 'Presenter (Poster)',
                                'early_bird' => '250',
                                'regular' => '300',
                                'description' => 'For poster presentations.',
                                'benefits' => ['Poster Display Space', 'Conference Proceedings', 'Lunch & Tea', 'Certificate']
                            ],
                            [
                                'name' => 'Listener',
                                'early_bird' => '200',
                                'regular' => '250',
                                'description' => 'Participation only.',
                                'benefits' => ['Access to Sessions', 'Lunch & Tea', 'Certificate']
                            ]
                        ]
                    ],
                    'domestic' => [
                        'title' => 'SAARC & Local Delegates',
                        'currency' => 'LKR',
                        'categories' => [
                            [
                                'name' => 'Local Presenter',
                                'early_bird' => '12,000',
                                'regular' => '15,000',
                                'description' => 'For Sri Lankan researchers.',
                                'benefits' => ['Presentation Slot', 'Lunch & Tea', 'Certificate']
                            ],
                            [
                                'name' => 'Student (Undergrad)',
                                'early_bird' => '5,000',
                                'regular' => '7,000',
                                'description' => 'Valid student ID required.',
                                'benefits' => ['Access to Sessions', 'Lunch & Tea', 'Certificate']
                            ],
                            [
                                'name' => 'Ayurvedic Practitioner',
                                'early_bird' => '8,000',
                                'regular' => '10,000',
                                'description' => 'Registered practitioners.',
                                'benefits' => ['Access to Sessions', 'Lunch & Tea', 'Certificate']
                            ]
                        ]
                    ]
                ]
            ],
            [
                'id' => 2,
                'slug' => 'climate-change-summit-2026',
                'title' => 'Climate Summit',
                'subtitle' => 'Global Action Plan',
                'date' => 'Nov 05-07, 2026',
                'time' => '08:30 AM - 04:30 PM',
                'formatted_date' => '05 Nov',
                'deadline' => 'Sep 05, 2026',
                'location' => 'London, UK',
                'venue' => 'ExCeL London',
                'country' => 'UK',
                'category' => 'Environment',
                'image' => 'https://images.unsplash.com/photo-1542601906990-b4d3fb7d5763?q=80&w=2800&auto=format&fit=crop',
                'description' => 'A critical gathering of scientists, policymakers, and activists to address the climate crisis.',
                'theme' => [
                    'primary' => '#10B981', // Emerald
                    'secondary' => '#064E3B',
                    'accent' => '#ffffff',
                    'gradient' => 'from-green-600 to-teal-900',
                ],
                'logo_text' => 'ECO:SUMMIT',
                'stats' => [],
                'speakers' => [],
                'schedule' => [],
                'tickets' => [] // Placeholder for others
            ],
            [
                'id' => 3,
                'slug' => 'fintech-future-2026',
                'title' => 'Future of Fintech 2026',
                'date' => 'Dec 10-12, 2026',
                'time' => '09:00 AM - 06:00 PM',
                'formatted_date' => '10 Dec',
                'deadline' => 'Oct 10, 2026',
                'location' => 'Singapore',
                'venue' => 'Marina Bay Sands',
                'country' => 'Singapore',
                'category' => 'Business',
                'image' => 'https://images.unsplash.com/photo-1556761175-5973dc0f32e7?q=80&w=2832&auto=format&fit=crop',
                'description' => 'Explore the latest trends in financial technology, blockchain, and digital payments.',
                'theme_color' => 'indigo',
            ],
            [
                'id' => 4,
                'slug' => 'world-health-congress-2027',
                'title' => 'World Health Innovation Congress',
                'date' => 'Jan 20-22, 2027',
                'time' => '08:00 AM - 05:00 PM',
                'formatted_date' => '20 Jan',
                'deadline' => 'Nov 20, 2026',
                'location' => 'Geneva, Switzerland',
                'venue' => 'Palexpo',
                'country' => 'Switzerland',
                'category' => 'Health',
                'image' => 'https://images.unsplash.com/photo-1576091160399-112ba8d25d1d?q=80&w=2940&auto=format&fit=crop',
                'description' => 'Showcasing breakthrough medical technologies and healthcare solutions for a better tomorrow.',
                'theme_color' => 'teal',
            ],
            [
                'id' => 5,
                'slug' => 'cybersecurity-defense-2027',
                'title' => 'Cybersecurity Defense Forum',
                'date' => 'Feb 15-17, 2027',
                'time' => '10:00 AM - 05:00 PM',
                'formatted_date' => '15 Feb',
                'deadline' => 'Dec 15, 2026',
                'location' => 'Washington, D.C.',
                'venue' => 'Walter E. Washington Convention Center',
                'country' => 'USA',
                'category' => 'Technology',
                'image' => 'https://images.unsplash.com/photo-1550751827-4bd374c3f58b?q=80&w=2940&auto=format&fit=crop',
                'description' => 'Strategies and tools for protecting digital assets in an increasingly connected world.',
                'theme_color' => 'red',
            ],
            [
                'id' => 6,
                'slug' => 'space-exploration-2027',
                'title' => 'Space Exploration Symposium',
                'date' => 'Mar 10-12, 2027',
                'time' => '09:00 AM - 05:00 PM',
                'formatted_date' => '10 Mar',
                'deadline' => 'Jan 10, 2027',
                'location' => 'Houston, TX',
                'venue' => 'Space Center Houston',
                'country' => 'USA',
                'category' => 'Science',
                'image' => 'https://images.unsplash.com/photo-1446776811953-b23d57bd21aa?q=80&w=2944&auto=format&fit=crop',
                'description' => 'Discussing the next frontier of human space travel and colonization.',
                'theme_color' => 'purple',
            ],
            [
                'id' => 8,
                'slug' => 'engineering-science-technology-2026',
                'prefix' => '4th International Conference on',
                'title' => 'Engineering, Science and Technology - Edition 01',
                'subtitle' => 'Sustainable Technology, Social Challenge, and Application',
                'date' => 'May 15-16, 2026',
                'time' => '09:00 AM - 05:00 PM',
                'formatted_date' => '15 May',
                'deadline' => 'Mar 15, 2026',
                'location' => 'Bangkok, Thailand',
                'venue' => 'Grand Hyatt Erawan',
                'country' => 'Thailand',
                'category' => 'Technology',
                'image' => 'https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?q=80&w=2940&auto=format&fit=crop',
                'description' => '4th International Conference on Engineering, Science and Technology - Edition 01. Exploring sustainable technology and social challenges.',
                'theme' => [
                    'primary' => '#0e7490', // Cyan 700
                    'secondary' => '#164e63', // Cyan 900
                    'accent' => '#67e8f9', // Cyan 300
                    'gradient' => 'from-cyan-800 to-blue-900',
                ],
                'logo_text' => 'EST:2026',
                'call_for_papers' => [
                    'text' => 'The 4th International Conference on Engineering, Science and Technology (EST 2026) invites researchers, scholars, and industry professionals to submit their original research papers and abstracts. The conference aims to provide a platform for discussing sustainable technological solutions to global social challenges. We welcome submissions in all areas of engineering, applied sciences, and technology management. All accepted papers will be published in Scopus-indexed proceedings.',
                    'link' => '#'
                ],
                'important_dates' => [
                    ['label' => 'Abstract Submission', 'date' => '15th March 2026'],
                    ['label' => 'Notification of Acceptance', 'date' => 'Within 10 Days'],
                    ['label' => 'Full Paper Submission', 'date' => '15th April 2026'],
                    ['label' => 'Early Bird Registration', 'date' => '30th March 2026'],
                    ['label' => 'Conference Dates', 'date' => '15-16 May 2026']
                ],
                'scopes' => [
                    'Engineering & Technology' => [
                        'Civil & Structural Engineering',
                        'Mechanical & Industrial Engineering',
                        'Electrical & Electronics Engineering',
                        'Computer Science & Information Systems',
                        'Chemical & Material Engineering'
                    ],
                    'Applied Sciences' => [
                        'Environmental Science & Sustainability',
                        'Biotechnology & Nanotechnology',
                        'Physics & Applied Mathematics',
                        'Chemistry & Material Science',
                        'Renewable Energy & Green Tech'
                    ],
                    'Social Challenges & Tech' => [
                        'Smart Cities & Urban Planning',
                        'Technology for Social Good',
                        'Ethical AI & Digital Privacy',
                        'Sustainable Development Goals (SDGs)',
                        'Education Technology (EdTech)'
                    ]
                ],
                'stats' => [
                    ['label' => 'Papers', 'value' => '150+'],
                    ['label' => 'Countries', 'value' => '35'],
                    ['label' => 'Workshops', 'value' => '8'],
                ],
                'speakers' => [
                    ['name' => 'Prof. David Lee', 'role' => 'Robotics Expert', 'company' => 'Tokyo Tech Inst', 'image' => 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?q=80&w=687&auto=format&fit=crop'],
                    ['name' => 'Dr. Maria Santos', 'role' => 'Civil Engineer', 'company' => 'Politecnico di Milano', 'image' => 'https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?q=80&w=687&auto=format&fit=crop'],
                    ['name' => 'Dr. Alan Grant', 'role' => 'AI Researcher', 'company' => 'Silicon Valley Labs', 'image' => 'https://images.unsplash.com/photo-1542909168-82c3e7fdca5c?q=80&w=1760&auto=format&fit=crop'],
                    ['name' => 'Prof. Emily Chen', 'role' => 'Green Energy', 'company' => 'National Univ', 'image' => 'https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=761&auto=format&fit=crop'],
                ],
                'schedule' => [
                    '15/05/2026' => [
                        'title' => 'Day 01: Engineering Innovations',
                        'events' => [
                            ['time' => '09:00 AM', 'title' => 'Opening Ceremony', 'speaker' => 'Committee'],
                            ['time' => '10:30 AM', 'title' => 'Robotics & Automation Future', 'speaker' => 'Prof. David Lee'],
                            ['time' => '02:00 PM', 'title' => 'Sustainable Infrastructure', 'speaker' => 'Dr. Maria Santos'],
                        ]
                    ],
                    '16/05/2026' => [
                        'title' => 'Day 02: Science & Society',
                        'events' => [
                            ['time' => '09:30 AM', 'title' => 'AI for Social Good', 'speaker' => 'Dr. Alan Grant'],
                            ['time' => '01:00 PM', 'title' => 'Renewable Energy Systems', 'speaker' => 'Prof. Emily Chen'],
                        ]
                    ]
                ],
                'registration' => [
                    'international' => [
                        'title' => 'International Delegates',
                        'currency' => 'USD',
                        'categories' => [
                            [
                                'name' => 'Presenter (Oral)',
                                'early_bird' => '400',
                                'regular' => '450',
                                'description' => 'Full paper presentation slot.',
                                'benefits' => ['20 min Presentation', 'Proceedings', 'Lunch & Gala Dinner', 'Certificate']
                            ],
                            [
                                'name' => 'Poster Presentation',
                                'early_bird' => '300',
                                'regular' => '350',
                                'description' => 'Display your research poster.',
                                'benefits' => ['Poster Spot', 'Proceedings', 'Lunch', 'Certificate']
                            ],
                            [
                                'name' => 'Listener',
                                'early_bird' => '250',
                                'regular' => '300',
                                'description' => 'Attend as a delegate.',
                                'benefits' => ['Access to Sessions', 'Conference Kit', 'Lunch', 'Certificate']
                            ]
                        ]
                    ],
                    'domestic' => [
                        'title' => 'Domestic (Thai) Delegates',
                        'currency' => 'THB',
                        'categories' => [
                            [
                                'name' => 'Local Presenter',
                                'early_bird' => '5,000',
                                'regular' => '6,000',
                                'description' => 'For Thai researchers.',
                                'benefits' => ['Presentation Slot', 'Lunch', 'Certificate']
                            ],
                            [
                                'name' => 'Student',
                                'early_bird' => '3,000',
                                'regular' => '4,000',
                                'description' => 'Valid student ID.',
                                'benefits' => ['Access to Sessions', 'Lunch', 'Certificate']
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }

    public function getConferenceBySlug($slug)
    {
        $conferences = $this->getAllConferences();
        $conference = collect($conferences)->firstWhere('slug', $slug);

        if (!$conference) {
            return null;
        }

        // Ensure date processing is applied if needed, though we hardcoded formatted values above for simplicity in mock data
        // Ideally, we process dates dynamically here if they weren't hardcoded.

        return $conference;
    }
}
