<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="scroll-smooth">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title ?? 'Conference' }} - Global Event</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <!-- Importing polished serif and sans-serif fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;0,700;1,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        [x-cloak] {
            display: none !important;
        }

        .font-serif {
            font-family: 'Playfair Display', serif;
        }

        .font-sans {
            font-family: 'Plus Jakarta Sans', sans-serif;
        }

        /* Modern Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #000;
        }

        ::-webkit-scrollbar-thumb {
            background: #333;
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
    </style>
</head>

<body class="font-sans antialiased text-gray-900 bg-white selection:bg-orange-500 selection:text-white">
    <!-- Modern Navigation -->
    <nav x-data="{ scrolled: false, mobileOpen: false }" @scroll.window="scrolled = (window.pageYOffset > 50)"
        :class="{ 'bg-black/80 backdrop-blur-md py-4': scrolled, 'bg-transparent py-8': !scrolled }"
        class="fixed w-full top-0 z-50 transition-all duration-300 border-b border-white/10">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="flex justify-between items-center">
                <!-- Dynamic Logo -->
                <div class="flex-shrink-0 flex items-center">
                    <a href="#" class="flex flex-col leading-none group">
                        @if(isset($conference['logo_text']))
                            <!-- Text Logo from Data -->
                            <span
                                class="text-white font-bold text-2xl tracking-tighter group-hover:text-orange-500 transition-colors">
                                {{ explode(':', $conference['logo_text'])[0] ?? 'CONF' }}<span
                                    class="font-light text-orange-500">:</span>{{ explode(':', $conference['logo_text'])[1] ?? 'EVENT' }}
                            </span>
                        @else
                            <span class="text-white font-bold text-2xl tracking-tighter">GARI<span
                                    class="text-orange-500">.</span></span>
                        @endif
                    </a>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#home"
                        class="text-sm font-medium tracking-wide text-white hover:text-orange-500 transition-colors uppercase">Home</a>
                    <a href="#submission"
                        class="text-sm font-medium tracking-wide text-white hover:text-orange-500 transition-colors uppercase">Papers</a>
                    <a href="#tickets"
                        class="text-sm font-medium tracking-wide text-white hover:text-orange-500 transition-colors uppercase">Registration</a>
                    <a href="#publications"
                        class="text-sm font-medium tracking-wide text-white hover:text-orange-500 transition-colors uppercase">Publications</a>

                    <a href="#register"
                        class="px-5 py-2 bg-white text-black font-bold text-sm tracking-wide hover:bg-orange-500 hover:text-white transition-all duration-300 uppercase clip-path-slant">
                        Register Now
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center">
                    <button @click="mobileOpen = !mobileOpen" class="text-white text-2xl focus:outline-none">
                        <i class="fas" :class="mobileOpen ? 'fa-times' : 'fa-bars'"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu Overlay -->
        <div x-show="mobileOpen" x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 translate-y-0"
            x-transition:leave-end="opacity-0 -translate-y-4"
            class="md:hidden absolute top-full left-0 w-full bg-black/95 backdrop-blur-xl border-t border-white/10 py-8 px-6 flex flex-col space-y-6 shadow-2xl">
            <a href="#home" @click="mobileOpen = false"
                class="text-white text-lg font-medium hover:text-orange-500 uppercase">Home</a>
            <a href="#submission" @click="mobileOpen = false"
                class="text-white text-lg font-medium hover:text-orange-500 uppercase">Papers / Abstract</a>
            <a href="#tickets" @click="mobileOpen = false"
                class="text-white text-lg font-medium hover:text-orange-500 uppercase">Registration Fees</a>
            <a href="#publications" @click="mobileOpen = false"
                class="text-white text-lg font-medium hover:text-orange-500 uppercase">Publications</a>
            <a href="#register" @click="mobileOpen = false"
                class="text-orange-500 text-lg font-bold hover:text-white uppercase">Register Now</a>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        {{ $slot }}
    </main>

    <!-- Footer -->
    <footer class="bg-black text-white pt-24 pb-12 border-t border-white/5 relative overflow-hidden">
        <!-- Background Glow -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-orange-600/10 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 w-full h-64 bg-gradient-to-t from-black to-transparent"></div>
        </div>

        <div class="max-w-7xl mx-auto px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-16 mb-20">
                <div class="col-span-1 md:col-span-1">
                    @if(isset($conference['logo_text']))
                        <h3 class="text-3xl font-bold tracking-tighter mb-8">
                            {{ explode(':', $conference['logo_text'])[0] ?? 'CONF' }}<span
                                class="text-orange-500">:</span>{{ explode(':', $conference['logo_text'])[1] ?? 'EVENT' }}
                        </h3>
                    @else
                        <h3 class="text-3xl font-bold tracking-tighter mb-8">GARI<span class="text-orange-500">.</span></h3>
                    @endif
                    <p class="text-gray-400 text-sm leading-relaxed mb-8">
                        We are shaping the future of global academic collaboration. providing a platform for innovation
                        and excellence.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#"
                            class="w-10 h-10 flex items-center justify-center rounded-full bg-white/5 hover:bg-orange-500 hover:text-white transition-all duration-300"><i
                                class="fab fa-twitter"></i></a>
                        <a href="#"
                            class="w-10 h-10 flex items-center justify-center rounded-full bg-white/5 hover:bg-orange-500 hover:text-white transition-all duration-300"><i
                                class="fab fa-linkedin-in"></i></a>
                        <a href="#"
                            class="w-10 h-10 flex items-center justify-center rounded-full bg-white/5 hover:bg-orange-500 hover:text-white transition-all duration-300"><i
                                class="fab fa-instagram"></i></a>
                    </div>
                </div>

                <div>
                    <h4 class="text-sm font-bold uppercase tracking-widest mb-8 text-white">Platform</h4>
                    <ul class="space-y-4 text-gray-400 text-sm font-medium">
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Program</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Speakers</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Sponsors</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Past Events</a></li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-sm font-bold uppercase tracking-widest mb-8 text-white">Support</h4>
                    <ul class="space-y-4 text-gray-400 text-sm font-medium">
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Contact Us</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">FAQ</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Privacy Policy</a></li>
                        <li><a href="#" class="hover:text-orange-500 transition-colors">Terms of Service</a></li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-sm font-bold uppercase tracking-widest mb-8 text-white">Subscribe</h4>
                    <p class="text-gray-400 text-sm mb-6">Get the latest updates and offers.</p>
                    <form class="flex border-b border-gray-700 pb-2">
                        <input type="email" placeholder="Email address"
                            class="bg-transparent border-none focus:ring-0 text-white placeholder-gray-500 w-full px-0">
                        <button type="button"
                            class="text-orange-500 hover:text-white transition-colors font-bold uppercase text-xs">Join</button>
                    </form>
                </div>
            </div>

            <div class="border-t border-white/10 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
                <p class="text-xs text-gray-500 uppercase tracking-wider">&copy; {{ date('Y') }} GARI Conference. All
                    rights reserved.</p>
                <div class="flex items-center gap-2">
                    <div class="h-1 w-1 rounded-full bg-green-500"></div>
                    <span class="text-xs text-gray-400">System Operational</span>
                </div>
            </div>
        </div>
    </footer>
</body>

</html>