<?php

namespace App\Http\Controllers;

use App\Services\ConferenceService;
use Illuminate\Http\Request;

class ConferenceSiteController extends Controller
{
    protected $conferenceService;

    public function __construct(ConferenceService $conferenceService)
    {
        $this->conferenceService = $conferenceService;
    }

    public function index($slug)
    {
        $conference = $this->conferenceService->getConferenceBySlug($slug);

        if (!$conference) {
            abort(404);
        }

        return view('conference.home', [
            'conference' => $conference
        ]);
    }
}
