<x-main-layout>
    <!-- Hero Section -->
    <div class="relative bg-slate-900 py-20 sm:py-32 overflow-hidden">
        <div class="absolute inset-0 overflow-hidden">
            <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80"
                alt="Conference Hall" class="w-full h-full object-cover opacity-20 transform scale-105">
            <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/80 to-transparent"></div>
        </div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center z-10">
            <h1 class="text-4xl sm:text-6xl font-bold text-white mb-6 tracking-tight leading-tight">
                Global Academic <br> <span
                    class="text-transparent bg-clip-text bg-gradient-to-r from-brand-400 to-cyan-400">Research
                    Institute</span>
            </h1>
            <p class="text-slate-300 text-lg sm:text-xl mb-10 max-w-3xl mx-auto leading-relaxed">
                GARI is a leading organization that provides a platform for researchers, academicians, and professionals
                to share their knowledge and experience.
            </p>


        </div>
    </div>

    <!-- About GARI Section -->
    <div class="py-16 bg-white border-b border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <h2 class="text-3xl font-bold text-slate-900 mb-6">About GARI</h2>
                    <p class="text-slate-600 mb-6 leading-relaxed">
                        Global Academic Research Institute (GARI) is an International Scientific Research Conference
                        Organizer. We have organized more than 100+ International Conferences in various countries. GARI
                        is a platform for researchers, academicians, and professionals to share their knowledge and
                        experience.
                    </p>
                    <p class="text-slate-600 mb-6 leading-relaxed">
                        We publish International Journals and Conference Proceedings. GARI is a member of the Crossref
                        and all published papers are assigned DOI.
                    </p>
                    <a href="#" class="text-brand-600 font-bold hover:text-brand-800 flex items-center gap-2">
                        Read More About Us <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                <div class="relative group cursor-pointer overflow-hidden rounded-xl shadow-lg">
                    <img src="https://images.unsplash.com/photo-1524178232363-1fb2b075b655?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80"
                        class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500"
                        alt="About GARI Conference">
                    <div
                        class="absolute inset-0 bg-black/20 group-hover:bg-black/30 transition-colors flex items-center justify-center">
                        <div
                            class="w-20 h-20 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center shadow-[0_0_0_8px_rgba(255,255,255,0.2)] group-hover:scale-110 transition-transform duration-300">
                            <div class="w-14 h-14 bg-white rounded-full flex items-center justify-center shadow-lg">
                                <i class="fas fa-play text-brand-600 text-xl pl-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Upcoming Conferences -->
    <div class="py-16 bg-slate-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-end mb-10">
                <div>
                    <h2 class="text-3xl font-bold text-slate-900 mb-2">Upcoming Conferences 2025</h2>
                    <p class="text-slate-500">Join our upcoming international conferences.</p>
                </div>
                <a href="{{ route('upcoming-conferences') }}"
                    class="text-brand-600 font-medium hover:text-brand-800 flex items-center gap-1">
                    View All <i class="fas fa-arrow-right text-sm"></i>
                </a>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @php
                    $conferences = [
                        [
                            'name' => 'International Conference on Artificial Intelligence 2025',
                            'date' => 'Oct 15-17, 2025',
                            'location' => 'Colombo, SL',
                            'image' => 'https://images.unsplash.com/photo-1540575467063-178a50c2df87?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80',
                            'category' => 'Technology'
                        ],
                        [
                            'name' => 'Global Summit on Climate Change',
                            'date' => 'Nov 05-07, 2025',
                            'location' => 'Bali, Indonesia',
                            'image' => 'https://images.unsplash.com/photo-1470071459604-3b5ec3a7fe05?ixlib=rb-4.0.3&auto=format&fit=crop&w=1948&q=80',
                            'category' => 'Environment'
                        ],
                        [
                            'name' => 'World Congress on Medical Science',
                            'date' => 'Dec 10-12, 2025',
                            'location' => 'Dubai, UAE',
                            'image' => 'https://images.unsplash.com/photo-1576091160399-112ba8d25d1d?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80',
                            'category' => 'Health'
                        ],
                        [
                            'name' => 'International Business & Economics Conference',
                            'date' => 'Jan 20-22, 2026',
                            'location' => 'Bangkok, Thailand',
                            'image' => 'https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80',
                            'category' => 'Business'
                        ]
                    ];
                @endphp
                @foreach($conferences as $conference)
                    <div
                        class="bg-white rounded-xl shadow-sm border border-slate-100 overflow-hidden hover:shadow-xl hover:-translate-y-1 transition-all duration-300 group">
                        <div class="h-48 overflow-hidden relative">
                            <img src="{{ $conference['image'] }}" alt="{{ $conference['name'] }}"
                                class="w-full h-full object-cover group-hover:scale-110 transition duration-700">

                        </div>
                        <div class="p-5">
                            <div class="flex items-center gap-2 text-xs text-slate-500 mb-3">
                                <span><i class="far fa-calendar-alt text-brand-500 mr-1"></i>
                                    {{ $conference['date'] }}</span>
                                <span>•</span>
                                <span><i class="fas fa-map-marker-alt text-brand-500 mr-1"></i>
                                    {{ $conference['location'] }}</span>
                            </div>
                            <h3
                                class="font-bold text-lg text-slate-900 mb-2 line-clamp-2 h-14 group-hover:text-brand-600 transition">
                                {{ $conference['name'] }}
                            </h3>
                            <div class="flex justify-between items-center pt-4 border-t border-slate-50">
                                <a href="#"
                                    class="text-sm font-medium text-white bg-slate-900 hover:bg-brand-600 px-4 py-2 rounded-lg transition w-full text-center">
                                    View Details
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>


    <!-- Awarded Researchers -->
    <div class="py-16 bg-white border-b border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Upcoming Keynotes and Chairs.</h2>
                <p class="text-slate-500 mt-2">Recognizing excellence in academic research and innovation.</p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6">
                <!-- Researcher 1 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Sarah Johnson"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Sarah Johnson</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">AI in Healthcare
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Neural networks for early disease
                                detection and personalized medicine.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 2 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1560250097-0b93528c311a?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Prof. James Chen"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Prof. James Chen</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Renewable Energy
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Next-generation solar cell efficiency
                                optimization.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 3 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1580489944761-15a19d654956?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Emily Williams"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Emily Williams</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Cognitive Science
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Brain-computer interface developments.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 4 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Michael Brown"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Michael Brown</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Cybersecurity
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Quantum cryptography protocols and safety.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 5 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Prof. Lisa Davis"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Prof. Lisa Davis</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Biotechnology
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">CRISPR applications in sustainable
                                agriculture.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Our Services -->
    <!-- Our Services -->
    <div class="py-16 bg-white border-b border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Our Services</h2>
                <p class="text-slate-500 mt-2">Comprehensive solutions for the academic and research community.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Service 1 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1544531586-fde5298cdd40?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Conference Organization"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">
                            Conference Organization</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            We organize world-class international conferences, providing a platform for global knowledge
                            exchange and networking.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Service 2 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1456513080510-7bf3a84b82f8?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Scientific Publishing"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">
                            Scientific Publishing</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            Publish your research in our high-impact journals and conference proceedings, indexed in
                            major databases with DOI.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Service 3 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1524178232363-1fb2b075b655?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Research Workshops"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">Research
                            Workshops</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            Join our specialized workshops and seminars designed to enhance your research skills and
                            academic development.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Service 4 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Global Networking"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">Global
                            Networking</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            Connect with leading researchers, academicians, and industry experts from around the world
                            to expand your professional network.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Service 5 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Academic Collaborations"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">Academic
                            Collaborations</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            Facilitating partnerships between universities and research institutions to drive innovation
                            and interdisciplinary study.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>

                <!-- Service 6 -->
                <div
                    class="bg-white rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Research Grants"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-2 group-hover:text-brand-600 transition">Research
                            Grants</h3>
                        <p class="text-slate-600 mb-4 text-sm leading-relaxed line-clamp-3">
                            Guidance and support for securing research funding and grants for your academic projects and
                            initiatives.
                        </p>
                        <a href="#"
                            class="text-brand-600 font-bold text-sm hover:text-brand-800 flex items-center gap-2">
                            View Details <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Previous Publications -->
    <div class="py-16 bg-slate-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Previous Publications</h2>
                <p class="text-slate-500 mt-2">Browse our collection of conference proceedings and journals.</p>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8">
                @php
                    $publications = [
                        ['year' => '2025', 'title' => 'Proceedings 2025', 'image' => 'https://images.unsplash.com/photo-1544947950-fa07a98d237f?auto=format&fit=crop&q=80&w=400&h=600'],
                        ['year' => '2024', 'title' => 'Proceedings 2024', 'image' => 'https://images.unsplash.com/photo-1512820790803-83ca734da794?auto=format&fit=crop&q=80&w=400&h=600'],
                        ['year' => '2023', 'title' => 'Proceedings 2023', 'image' => 'https://images.unsplash.com/photo-1532012197267-da84d127e765?auto=format&fit=crop&q=80&w=400&h=600'],
                        ['year' => '2022', 'title' => 'Proceedings 2022', 'image' => 'https://images.unsplash.com/photo-1589829085413-56de8ae18c73?auto=format&fit=crop&q=80&w=400&h=600'],
                    ];
                @endphp
                @foreach($publications as $pub)
                    <a href="{{ url('/publications/' . $pub['year']) }}"
                        class="group relative block aspect-[2/3] bg-gray-200 rounded-lg overflow-hidden shadow-md hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                        <img src="{{ $pub['image'] }}" alt="{{ $pub['title'] }}" class="w-full h-full object-cover">
                        <div
                            class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                            <span
                                class="text-white font-bold border-2 border-white px-6 py-2 rounded-full hover:bg-white hover:text-black transition">View
                                All</span>
                        </div>
                        <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/80 to-transparent p-4">
                            <h3 class="text-white font-bold text-lg">{{ $pub['title'] }}</h3>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Awarded Researchers -->
    <div class="py-16 bg-white border-b border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Awarded Researchers</h2>
                <p class="text-slate-500 mt-2">Recognizing excellence in academic research and innovation.</p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6">
                <!-- Researcher 1 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Sarah Johnson"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Sarah Johnson</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">AI in Healthcare
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Neural networks for early disease
                                detection and personalized medicine.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 2 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1560250097-0b93528c311a?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Prof. James Chen"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Prof. James Chen</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Renewable Energy
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Next-generation solar cell efficiency
                                optimization.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 3 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1580489944761-15a19d654956?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Emily Williams"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Emily Williams</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Cognitive Science
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Brain-computer interface developments.</p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 4 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Dr. Michael Brown"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Dr. Michael Brown</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Cybersecurity
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">Quantum cryptography protocols and safety.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Researcher 5 -->
                <div
                    class="bg-slate-50 rounded-xl overflow-hidden border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="h-48 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                            alt="Prof. Lisa Davis"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                    </div>
                    <div class="p-5">
                        <h3 class="font-bold text-slate-900 text-lg mb-1">Prof. Lisa Davis</h3>
                        <div class="text-xs font-semibold text-brand-600 uppercase tracking-wide mb-3">Biotechnology
                        </div>

                        <div>
                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Future
                                Research</div>
                            <p class="text-slate-600 text-xs leading-relaxed">CRISPR applications in sustainable
                                agriculture.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Directory -->
    <div class="py-16 bg-slate-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Gallery Section -->
            <!-- Gallery Section -->
            <div class="mb-20 space-y-16">

                <!-- Photo Albums -->
                <div>
                    <div class="flex flex-col md:flex-row justify-between items-end mb-8">
                        <div>
                            <h2 class="text-3xl font-bold text-slate-900">Event Albums</h2>
                            <p class="text-slate-500 mt-2 max-w-xl">Explore moments from our past academic gatherings.
                            </p>
                        </div>
                        <a href="#"
                            class="text-brand-600 hover:text-brand-800 font-medium mt-4 md:mt-0 group flex items-center gap-2 border border-brand-200 px-4 py-2 rounded-full hover:bg-brand-50 transition">
                            View All Albums <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
                        <!-- Album 1 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1544531586-fde5298cdd40?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div class="absolute inset-0 bg-black/20 group-hover:bg-black/10 transition-colors">
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full flex items-center gap-1">
                                    <i class="fas fa-camera"></i> 24 Photos
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">Annual
                                Conference 2024</h3>
                            <p class="text-slate-500 text-sm">London, UK • Oct 15-17</p>
                        </div>

                        <!-- Album 2 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1544531586-fde5298cdd40?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div class="absolute inset-0 bg-black/20 group-hover:bg-black/10 transition-colors">
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full flex items-center gap-1">
                                    <i class="fas fa-camera"></i> 42 Photos
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">Award
                                Ceremony 2024</h3>
                            <p class="text-slate-500 text-sm">Dubai, UAE • Dec 10</p>
                        </div>

                        <!-- Album 3 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1560523159-4a9692d222ef?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div class="absolute inset-0 bg-black/20 group-hover:bg-black/10 transition-colors">
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full flex items-center gap-1">
                                    <i class="fas fa-camera"></i> 18 Photos
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">
                                Networking Session</h3>
                            <p class="text-slate-500 text-sm">Singapore • Nov 05</p>
                        </div>
                    </div>
                </div>

                <!-- Video Gallery -->
                <div>
                    <div class="flex flex-col md:flex-row justify-between items-end mb-8">
                        <div>
                            <h2 class="text-3xl font-bold text-slate-900">Video Highlights</h2>
                            <p class="text-slate-500 mt-2 max-w-xl">Watch keynote speeches and event summaries.</p>
                        </div>
                        <a href="#"
                            class="text-brand-600 hover:text-brand-800 font-medium mt-4 md:mt-0 group flex items-center gap-2 border border-brand-200 px-4 py-2 rounded-full hover:bg-brand-50 transition">
                            View All Videos <i
                                class="fas fa-arrow-right transition-transform group-hover:translate-x-1"></i>
                        </a>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
                        <!-- Video 1 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div
                                    class="absolute inset-0 bg-black/30 group-hover:bg-black/50 transition-colors flex items-center justify-center">
                                    <div class="w-16 h-16 bg-white/20 backdrop-blur-md rounded-full flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition duration-300 shadow-lg border border-white/50"
                                        style="width: 4rem; height: 4rem; min-width: 4rem; min-height: 4rem;">
                                        <i class="fas fa-play text-white text-2xl pl-1"></i>
                                    </div>
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full">
                                    02:45
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">Keynote
                                Highlights 2024</h3>
                            <p class="text-slate-500 text-sm">Prof. James Chen</p>
                        </div>

                        <!-- Video 2 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div
                                    class="absolute inset-0 bg-black/30 group-hover:bg-black/50 transition-colors flex items-center justify-center">
                                    <div class="w-16 h-16 bg-white/20 backdrop-blur-md rounded-full flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition duration-300 shadow-lg border border-white/50"
                                        style="width: 4rem; height: 4rem; min-width: 4rem; min-height: 4rem;">
                                        <i class="fas fa-play text-white text-2xl pl-1"></i>
                                    </div>
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full">
                                    05:12
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">
                                Conference Summary</h3>
                            <p class="text-slate-500 text-sm">Global Summit on Climate Change</p>
                        </div>

                        <!-- Video 3 -->
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden rounded-xl shadow-sm mb-4">
                                <div class="aspect-video">
                                    <img src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?auto=format&fit=crop&q=80&w=800"
                                        class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                                </div>
                                <div
                                    class="absolute inset-0 bg-black/30 group-hover:bg-black/50 transition-colors flex items-center justify-center">
                                    <div class="w-16 h-16 bg-white/20 backdrop-blur-md rounded-full flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition duration-300 shadow-lg border border-white/50"
                                        style="width: 4rem; height: 4rem; min-width: 4rem; min-height: 4rem;">
                                        <i class="fas fa-play text-white text-2xl pl-1"></i>
                                    </div>
                                </div>
                                <div
                                    class="absolute bottom-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-bold px-3 py-1 rounded-full">
                                    01:30
                                </div>
                            </div>
                            <h3 class="font-bold text-lg text-slate-900 group-hover:text-brand-600 transition">Workshop
                                Teaser</h3>
                            <p class="text-slate-500 text-sm">AI in Healthcare</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <!-- Submission Guidelines Summary -->
    <div class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Submission Guidelines</h2>
                <p class="text-slate-600 mt-2">Everything you need to know about submitting your research.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Abstract -->
                <a href="{{ route('guidelines') }}#abstract"
                    class="bg-white p-8 rounded-xl shadow-sm border border-slate-100 hover:shadow-lg hover:-translate-y-1 transition group">
                    <div
                        class="w-14 h-14 bg-amber-100 rounded-full flex items-center justify-center mb-6 group-hover:bg-amber-500 transition">
                        <i class="fas fa-file-alt text-amber-600 text-2xl group-hover:text-white transition"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3 group-hover:text-amber-600 transition">Abstract
                        Submission</h3>
                    <p class="text-slate-500 text-sm mb-4">Guidelines for submitting your research abstract, including
                        word limits and formatting.</p>
                    <span class="text-amber-600 font-bold text-sm flex items-center gap-2">View Guidelines <i
                            class="fas fa-arrow-right"></i></span>
                </a>

                <!-- Full Paper -->
                <a href="{{ route('guidelines') }}#full-paper"
                    class="bg-white p-8 rounded-xl shadow-sm border border-slate-100 hover:shadow-lg hover:-translate-y-1 transition group">
                    <div
                        class="w-14 h-14 bg-brand-100 rounded-full flex items-center justify-center mb-6 group-hover:bg-brand-500 transition">
                        <i class="fas fa-book text-brand-600 text-2xl group-hover:text-white transition"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3 group-hover:text-brand-600 transition">Full Paper
                        Submission</h3>
                    <p class="text-slate-500 text-sm mb-4">Detailed requirements for full paper submissions, including
                        length, structure, and referencing.</p>
                    <span class="text-brand-600 font-bold text-sm flex items-center gap-2">View Guidelines <i
                            class="fas fa-arrow-right"></i></span>
                </a>

                <!-- Presentation -->
                <a href="{{ route('guidelines') }}#presentation"
                    class="bg-white p-8 rounded-xl shadow-sm border border-slate-100 hover:shadow-lg hover:-translate-y-1 transition group">
                    <div
                        class="w-14 h-14 bg-emerald-100 rounded-full flex items-center justify-center mb-6 group-hover:bg-emerald-500 transition">
                        <i
                            class="fas fa-chalkboard-teacher text-emerald-600 text-2xl group-hover:text-white transition"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3 group-hover:text-emerald-600 transition">
                        Presentation Guidelines</h3>
                    <p class="text-slate-500 text-sm mb-4">Information on oral presentations, time allocation, and
                        language requirements.</p>
                    <span class="text-emerald-600 font-bold text-sm flex items-center gap-2">View Guidelines <i
                            class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </div>

    <!-- Affiliations and Collaborations -->
    <div class="py-16 bg-slate-50 border-t border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Affiliations and Collaborations</h2>
                <p class="text-slate-500 mt-2">Building global bridges for academic excellence.</p>
            </div>

            <div class="mb-12">

                <div
                    class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-x-8 gap-y-12 items-center justify-items-center">
                    @for($i = 0; $i < 6; $i++)
                        <div class="group cursor-pointer text-center">
                            <i
                                class="fas fa-university text-4xl text-slate-300 group-hover:text-brand-600 transition-all duration-300 transform group-hover:scale-110"></i>

                        </div>
                    @endfor
                </div>
            </div>


        </div>
    </div>

    <!-- Media Partners / Publishers / Sponsors -->


    <!-- Publish Your Paper Section -->
    <div class="py-20 bg-brand-900 relative overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <img src="https://images.unsplash.com/photo-1456513080510-7bf3a84b82f8?ixlib=rb-4.0.3&auto=format&fit=crop&w=2073&q=80"
                class="w-full h-full object-cover">
        </div>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 text-center">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">Publish Your Research with GARI</h2>
            <p class="text-brand-100 text-lg max-w-2xl mx-auto mb-10">
                Submit your research paper for peer review and publication in our high-impact international journals. We
                ensure a rigorous review process and global dissemination of your work.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="#"
                    class="bg-white text-brand-900 font-bold py-3 px-8 rounded-full hover:bg-brand-50 transition shadow-lg transform hover:-translate-y-1">
                    Submit Paper
                </a>
                <a href="#"
                    class="bg-transparent border-2 border-white text-white font-bold py-3 px-8 rounded-full hover:bg-white/10 transition transform hover:-translate-y-1">
                    View Guidelines
                </a>
            </div>
            <div class="mt-12 grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
                <div>
                    <div class="text-3xl font-bold text-white mb-1">50+</div>
                    <div class="text-brand-200 text-sm">International Journals</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-white mb-1">10k+</div>
                    <div class="text-brand-200 text-sm">Published Papers</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-white mb-1">DOI</div>
                    <div class="text-brand-200 text-sm">Assigned to All Papers</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-white mb-1">Open</div>
                    <div class="text-brand-200 text-sm">Access Availability</div>
                </div>
            </div>
        </div>
    </div>




    <!-- Collaborations -->

    </div>
    </div>



    <!-- Media Partners / Publishers / Sponsors -->
    <div class="py-16 bg-slate-50 border-t border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-slate-900">Media Partners / Publishers / Sponsors</h2>
                <p class="text-slate-500 mt-2">Our trusted partners in dissemination and support.</p>
            </div>

            <div
                class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-x-8 gap-y-12 items-center justify-items-center">
                @php
                    $partners = [
                        ['icon' => 'fa-book-reader', 'name' => 'Springer'],
                        ['icon' => 'fa-newspaper', 'name' => 'Taylor & Francis'],
                        ['icon' => 'fa-scroll', 'name' => 'Scopus'],
                        ['icon' => 'fa-globe', 'name' => 'Wiley'],
                        ['icon' => 'fa-search', 'name' => 'Google Scholar'],
                        ['icon' => 'fa-database', 'name' => 'ProQuest'],
                    ];
                @endphp
                @foreach($partners as $partner)
                    <div class="group cursor-pointer text-center">
                        <i
                            class="fas {{ $partner['icon'] }} text-4xl text-slate-300 group-hover:text-brand-600 transition-all duration-300 transform group-hover:scale-110"></i>
                        <p
                            class="mt-3 text-xs text-slate-400 group-hover:text-slate-600 transition-colors opacity-0 group-hover:opacity-100">
                            {{ $partner['name'] }}
                        </p>
                    </div>
                @endforeach
            </div>
        </div>
    </div>


    <!-- Conferences Directory -->
    <div class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
                <!-- Continents Sidebar -->
                <div class="lg:col-span-1 space-y-8">
                    <div class="bg-slate-50 rounded-xl p-6 border border-slate-100">
                        <h3 class="font-bold text-slate-900 mb-4 border-b border-slate-200 pb-2">Featured Conferences by
                            Continents</h3>
                        <div class="space-y-6">
                            <div>
                                <h4 class="font-bold text-brand-600 text-sm mb-2 flex items-center gap-2">
                                    <i class="fas fa-globe-africa"></i> Africa
                                </h4>
                                <ul class="grid grid-cols-2 gap-2 text-xs text-slate-600">
                                    <li><a href="#" class="hover:text-brand-600">Ghana</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Kenya</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Morocco</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Nigeria</a></li>
                                    <li><a href="#" class="hover:text-brand-600">South Africa</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Egypt</a></li>
                                </ul>
                            </div>
                            <div>
                                <h4 class="font-bold text-brand-600 text-sm mb-2 flex items-center gap-2">
                                    <i class="fas fa-globe-asia"></i> Asia
                                </h4>
                                <ul class="grid grid-cols-2 gap-2 text-xs text-slate-600">
                                    <li><a href="#" class="hover:text-brand-600">China</a></li>
                                    <li><a href="#" class="hover:text-brand-600">India</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Japan</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Singapore</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Thailand</a></li>
                                    <li><a href="#" class="hover:text-brand-600">UAE</a></li>
                                </ul>
                            </div>
                            <div>
                                <h4 class="font-bold text-brand-600 text-sm mb-2 flex items-center gap-2">
                                    <i class="fas fa-globe-europe"></i> Europe
                                </h4>
                                <ul class="grid grid-cols-2 gap-2 text-xs text-slate-600">
                                    <li><a href="#" class="hover:text-brand-600">France</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Germany</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Italy</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Spain</a></li>
                                    <li><a href="#" class="hover:text-brand-600">UK</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Netherlands</a></li>
                                </ul>
                            </div>
                            <div>
                                <h4 class="font-bold text-brand-600 text-sm mb-2 flex items-center gap-2">
                                    <i class="fas fa-globe-americas"></i> North America
                                </h4>
                                <ul class="grid grid-cols-2 gap-2 text-xs text-slate-600">
                                    <li><a href="#" class="hover:text-brand-600">USA</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Canada</a></li>
                                    <li><a href="#" class="hover:text-brand-600">Mexico</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Submit your Events -->
                    <div class="mt-8">
                        <a href="#"
                            class="block w-full bg-brand-600 text-white font-bold py-3 px-6 rounded-xl hover:bg-brand-700 transition text-center shadow-md hover:shadow-lg transform hover:-translate-y-1">
                            Submit your Events
                        </a>
                    </div>
                </div>

                <!-- Topics Main Content -->
                <div class="lg:col-span-3">
                    <h3 class="font-bold text-slate-900 text-xl mb-6 border-b border-slate-200 pb-4">GARI Journals and
                        Academic Book Publication</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @php
                            $latestWorks = [
                                [
                                    'type' => 'Journal',
                                    'title' => 'GARI International Journal of Multidisciplinary Research',
                                    'image' => 'https://images.unsplash.com/photo-1544947950-fa07a98d237f?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISSN 2424-6492',
                                    'meta' => 'Vol. 05, Issue 02',
                                    'color' => 'red'
                                ],
                                [
                                    'type' => 'Book',
                                    'title' => 'Advanced Research Methodologies in Social Sciences',
                                    'image' => 'https://images.unsplash.com/photo-1512820790803-83ca734da794?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISBN 978-1-56619-909-4',
                                    'meta' => 'By Dr. Sarah Johnson',
                                    'color' => 'blue'
                                ],
                                [
                                    'type' => 'Journal',
                                    'title' => 'International Journal of Enhanced Research in Science',
                                    'image' => 'https://images.unsplash.com/photo-1532012197267-da84d127e765?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISSN 2319-7463',
                                    'meta' => 'Vol. 12, Issue 04',
                                    'color' => 'red'
                                ],
                                [
                                    'type' => 'Book',
                                    'title' => 'Sustainable Development And Green Technology',
                                    'image' => 'https://images.unsplash.com/photo-1589829085413-56de8ae18c73?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISBN 978-0-12345-678-9',
                                    'meta' => 'By Prof. James Chen',
                                    'color' => 'blue'
                                ],
                                [
                                    'type' => 'Journal',
                                    'title' => 'Global Journal of Business Management and Economics',
                                    'image' => 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISSN 1234-5678',
                                    'meta' => 'Vol. 08, Issue 01',
                                    'color' => 'red'
                                ],
                                [
                                    'type' => 'Book',
                                    'title' => 'Digital Transformation in Modern Education',
                                    'image' => 'https://images.unsplash.com/photo-1506880018603-83d5b814b5a6?auto=format&fit=crop&q=80&w=400&h=600',
                                    'number' => 'ISBN 978-3-16-148410-0',
                                    'meta' => 'By Dr. Emily Williams',
                                    'color' => 'blue'
                                ],
                            ];
                        @endphp

                        @foreach($latestWorks as $work)
                            <a href="#"
                                class="group bg-white rounded-xl border border-slate-100 shadow-sm hover:shadow-lg hover:-translate-y-1 transition-all duration-300 overflow-hidden flex flex-col h-full">
                                <div class="relative h-48 overflow-hidden">
                                    <img src="{{ $work['image'] }}" alt="{{ $work['title'] }}"
                                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                                    <div class="absolute top-3 left-3">
                                        <span
                                            class="px-3 py-1 bg-white/90 backdrop-blur-sm text-xs font-bold text-slate-900 rounded-full shadow-sm border border-slate-100 flex items-center gap-1.5">
                                            <span
                                                class="w-1.5 h-1.5 rounded-full {{ $work['color'] == 'red' ? 'bg-red-500' : 'bg-blue-500' }}"></span>
                                            {{ $work['type'] }}
                                        </span>
                                    </div>
                                </div>
                                <div class="p-5 flex flex-col flex-grow">
                                    <h4
                                        class="font-bold text-slate-900 leading-snug mb-2 mb-auto group-hover:text-brand-600 transition line-clamp-2">
                                        {{ $work['title'] }}
                                    </h4>

                                    <div class="mt-4 space-y-2">
                                        <div
                                            class="flex items-center gap-2 text-xs text-slate-500 bg-slate-50 px-2.5 py-1.5 rounded-lg">
                                            <i class="fas fa-barcode text-slate-400"></i>
                                            <span class="font-mono font-medium text-slate-600">{{ $work['number'] }}</span>
                                        </div>
                                        <div class="flex items-center gap-2 text-xs text-slate-500 px-1">
                                            <i
                                                class="{{ $work['type'] == 'Journal' ? 'fas fa-layer-group' : 'fas fa-user-edit' }} text-slate-400 w-4 text-center"></i>
                                            <span>{{ $work['meta'] }}</span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
    </div>
    </div>


    <!-- Latest News Section -->
    <div class="py-16 bg-slate-50 border-t border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center gap-3">
                    <div class="w-1 h-6 bg-brand-500 rounded-full"></div>
                    <h3 class="text-xl font-bold text-slate-900">Latest News & Updates</h3>
                </div>
                <a href="#"
                    class="text-sm font-medium text-brand-600 hover:text-brand-800 flex items-center gap-1 group">
                    View All News <i
                        class="fas fa-arrow-right text-xs group-hover:translate-x-1 transition-transform"></i>
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                @php
                    $newsItems = [
                        [
                            'title' => 'GARI Launches New Journal on AI Ethics',
                            'date' => 'OCT 25, 2025',
                            'category' => 'Publication',
                            'excerpt' => 'We are proud to announce the launch of our newest journal focusing on the ethical implications of Artificial Intelligence.',
                            'image' => 'https://images.unsplash.com/photo-1620712943543-bcc4688e7485?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80'
                        ],
                        [
                            'title' => 'Call for Papers: Climate Change Summit 2025',
                            'date' => 'NOV 10, 2025',
                            'category' => 'Conference',
                            'excerpt' => 'Researchers are invited to submit their papers for the upcoming Global Summit on Climate Change in Bali.',
                            'image' => 'https://images.unsplash.com/photo-1470071459604-3b5ec3a7fe05?ixlib=rb-4.0.3&auto=format&fit=crop&w=1948&q=80'
                        ],
                        [
                            'title' => 'Best Paper Awards Announced for ICMHS 2024',
                            'date' => 'SEP 15, 2025',
                            'category' => 'Awards',
                            'excerpt' => 'Congratulations to the winners of the Best Paper Awards at the International Conference on Medical & Health Sciences.',
                            'image' => 'https://images.unsplash.com/photo-1576091160399-112ba8d25d1d?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80'
                        ],
                        [
                            'title' => 'New Partnership with World Research Alliance',
                            'date' => 'AUG 05, 2025',
                            'category' => 'Partnership',
                            'excerpt' => 'GARI has entered into a strategic partnership with the World Research Alliance to foster global collaboration.',
                            'image' => 'https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-4.0.3&auto=format&fit=crop&w=2069&q=80'
                        ]
                    ];
                @endphp
                @foreach($newsItems as $news)
                    <div
                        class="flex gap-4 p-4 rounded-xl border border-slate-100 hover:border-brand-100 hover:shadow-lg hover:bg-brand-50/30 transition group bg-white">
                        <div class="w-24 h-24 flex-shrink-0 rounded-lg overflow-hidden relative">
                            <img src="{{ $news['image'] }}"
                                class="w-full h-full object-cover group-hover:scale-105 transition">
                        </div>
                        <div class="flex-grow min-w-0">
                            <div class="flex items-center gap-2 mb-1">
                                <span
                                    class="text-[10px] font-bold uppercase tracking-wider text-brand-600 bg-brand-50 px-2 py-0.5 rounded-full">{{ $news['category'] }}</span>
                                <span class="text-[10px] text-slate-400">{{ $news['date'] }}</span>
                            </div>
                            <h4
                                class="font-bold text-slate-900 text-sm mb-2 line-clamp-2 group-hover:text-brand-600 transition">
                                {{ $news['title'] }}
                            </h4>
                            <p class="text-xs text-slate-500 line-clamp-2 mb-2">{{ $news['excerpt'] }}</p>
                            <a href="#"
                                class="text-xs font-medium text-brand-600 hover:text-brand-800 flex items-center gap-1">Read
                                More <i class="fas fa-arrow-right text-[10px]"></i></a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>




</x-main-layout>